/*
 * Decompiled with CFR 0.152.
 */
package org.projecttick.projtlauncher.legacy.utils.url;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.projecttick.projtlauncher.normal.utils.logging.Log;

public final class UrlUtils {
    private static URLStreamHandler http;
    private static MethodHandle openConnection;

    public static boolean isSupported() {
        return http != null && openConnection != null;
    }

    public static URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        if (http == null) {
            throw new UnsupportedOperationException();
        }
        if (uRL.getProtocol().equals("http")) {
            return UrlUtils.openConnection(http, uRL, proxy);
        }
        return uRL.openConnection();
    }

    public static URLConnection openConnection(URLStreamHandler uRLStreamHandler, URL uRL, Proxy proxy) throws IOException {
        if (openConnection == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return openConnection.invokeExact(uRLStreamHandler, uRL, proxy);
        }
        catch (IOException | Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new AssertionError("openConnection should not throw", throwable);
        }
    }

    static {
        try {
            Method method = URL.class.getDeclaredMethod("getURLStreamHandler", String.class);
            method.setAccessible(true);
            http = (URLStreamHandler)method.invoke(null, "http");
            Method method2 = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
            method2.setAccessible(true);
            openConnection = MethodHandles.lookup().unreflect(method2);
        }
        catch (Throwable throwable) {
            Log.error((String)"URL reflection failed - some features may not work", (Throwable)throwable);
        }
    }
}

