/*
 * Decompiled with CFR 0.152.
 */
package org.projecttick.projtlauncher.legacy.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import org.projecttick.projtlauncher.normal.utils.logging.Log;

public final class Base64 {
    private static boolean supported = true;
    private static MethodHandle legacy;

    public static boolean isSupported() {
        return supported;
    }

    public static byte[] decode(String string) {
        if (!Base64.isSupported()) {
            throw new UnsupportedOperationException();
        }
        if (legacy == null) {
            return java.util.Base64.getDecoder().decode(string.getBytes(StandardCharsets.UTF_8));
        }
        try {
            return legacy.invokeExact(string);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
    }

    static {
        try {
            Class.forName("java.util.Base64");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class<?> clazz = Class.forName("javax.xml.bind.DatatypeConverter");
                legacy = MethodHandles.lookup().findStatic(clazz, "parseBase64Binary", MethodType.methodType(byte[].class, String.class));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                Log.error((String)"Base64 not supported", (Throwable)reflectiveOperationException);
                supported = false;
            }
        }
    }
}

