/*
 * Decompiled with CFR 0.152.
 */
package org.projecttick.projtlauncher.normal.utils.logging;

import java.io.PrintStream;
import org.projecttick.projtlauncher.normal.utils.logging.Level;

public final class Log {
    private static final PrintStream OUT = new PrintStream(System.out);
    private static final PrintStream ERR = new PrintStream(System.err);
    private static final boolean DEBUG = Boolean.getBoolean("org.projecttick.projtlauncher.normal.debug");

    public static void launcher(String string) {
        Log.log(string, Level.LAUNCHER);
    }

    public static void error(String string) {
        Log.log(string, Level.ERROR);
    }

    public static void debug(String string) {
        Log.log(string, Level.DEBUG);
    }

    public static void warning(String string) {
        Log.log(string, Level.WARNING);
    }

    public static void error(String string, Throwable throwable) {
        Log.error(string);
        throwable.printStackTrace(ERR);
    }

    public static void fatal(String string) {
        Log.log(string, Level.FATAL);
    }

    public static void fatal(String string, Throwable throwable) {
        Log.fatal(string);
        throwable.printStackTrace(ERR);
    }

    public static void log(String string, Level level) {
        if (!DEBUG && level == Level.DEBUG) {
            return;
        }
        String string2 = "!![" + level.name + "]!";
        string = string2 + string;
        string = string.replace("\n", "\n" + string2);
        if (level.stderr) {
            ERR.println(string);
        } else {
            OUT.println(string);
        }
    }
}

