/*
 * Decompiled with CFR 0.152.
 */
package tr.org.yongdohyun.projtlauncher.normal.launcher.impl;

import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import tr.org.yongdohyun.projtlauncher.normal.launcher.impl.AbstractLauncher;
import tr.org.yongdohyun.projtlauncher.normal.utils.Parameters;
import tr.org.yongdohyun.projtlauncher.normal.utils.ReflectionUtils;

public final class StandardLauncher
extends AbstractLauncher {
    private final boolean quickPlayMultiplayerSupported;
    private final boolean quickPlaySingleplayerSupported;

    public StandardLauncher(Parameters parameters) {
        super(parameters);
        List<String> list = parameters.getList("traits", Collections.emptyList());
        this.quickPlayMultiplayerSupported = list.contains("feature:is_quick_play_multiplayer");
        this.quickPlaySingleplayerSupported = list.contains("feature:is_quick_play_singleplayer");
    }

    @Override
    public void launch() throws Throwable {
        this.gameArgs.add("--width");
        this.gameArgs.add(Integer.toString(this.width));
        this.gameArgs.add("--height");
        this.gameArgs.add(Integer.toString(this.height));
        if (this.serverAddress != null) {
            if (this.quickPlayMultiplayerSupported) {
                this.gameArgs.add("--quickPlayMultiplayer");
                this.gameArgs.add(this.serverAddress + ':' + this.serverPort);
            } else {
                this.gameArgs.add("--server");
                this.gameArgs.add(this.serverAddress);
                this.gameArgs.add("--port");
                this.gameArgs.add(this.serverPort);
            }
        } else if (this.worldName != null && this.quickPlaySingleplayerSupported) {
            this.gameArgs.add("--quickPlaySingleplayer");
            this.gameArgs.add(this.worldName);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.gameArgs) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\u001f');
            }
            stringBuilder.append(string);
        }
        System.setProperty("tr.org.yongdohyun.projtlauncher.normal.launch.mainclass", this.mainClassName);
        System.setProperty("tr.org.yongdohyun.projtlauncher.normal.launch.gameargs", stringBuilder.toString());
        MethodHandle methodHandle = ReflectionUtils.findMainMethod(this.mainClassName);
        methodHandle.invokeExact(this.gameArgs.toArray(new String[0]));
    }
}

