/*
 * Decompiled with CFR 0.152.
 */
package tr.org.yongdohyun.projtlauncher.legacy.fix.online;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import tr.org.yongdohyun.projtlauncher.legacy.utils.api.MojangApi;
import tr.org.yongdohyun.projtlauncher.legacy.utils.api.Texture;
import tr.org.yongdohyun.projtlauncher.legacy.utils.url.ByteArrayUrlConnection;
import tr.org.yongdohyun.projtlauncher.legacy.utils.url.UrlUtils;

final class SkinFix {
    SkinFix() {
    }

    static URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        String string = SkinFix.findSkinOwner(uRL);
        if (string != null) {
            return SkinFix.getSkinConnection(string, proxy);
        }
        String string2 = SkinFix.findCapeOwner(uRL);
        if (string2 != null) {
            Texture texture = MojangApi.getTexture(MojangApi.getUuid(string2), "CAPE");
            if (texture == null) {
                return null;
            }
            return UrlUtils.openConnection(texture.getUrl(), proxy);
        }
        return null;
    }

    private static URLConnection getSkinConnection(String string, Proxy proxy) throws IOException {
        Texture texture = MojangApi.getTexture(MojangApi.getUuid(string), "SKIN");
        if (texture == null) {
            return null;
        }
        URLConnection uRLConnection = UrlUtils.openConnection(texture.getUrl(), proxy);
        try (InputStream inputStream = uRLConnection.getInputStream();){
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = ImageIO.read(inputStream);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            if (bufferedImage2.getHeight() > 32) {
                bufferedImage = bufferedImage2.getSubimage(0, 32, 56, 16);
                graphics2D.drawImage((Image)bufferedImage, 0, 16, null);
            }
            if (texture.isSlim()) {
                bufferedImage = bufferedImage2.getSubimage(45, 16, 9, 16);
                graphics2D.drawImage((Image)bufferedImage, 46, 16, null);
                bufferedImage = bufferedImage2.getSubimage(49, 16, 2, 4);
                graphics2D.drawImage((Image)bufferedImage, 50, 16, null);
                bufferedImage = bufferedImage2.getSubimage(53, 20, 2, 12);
                graphics2D.drawImage((Image)bufferedImage, 54, 20, null);
            }
            graphics2D.dispose();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedImage2 = bufferedImage2.getSubimage(0, 0, 64, 32);
            ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
            ByteArrayUrlConnection byteArrayUrlConnection = new ByteArrayUrlConnection(byteArrayOutputStream.toByteArray());
            return byteArrayUrlConnection;
        }
    }

    private static String findSkinOwner(URL uRL) {
        switch (uRL.getHost()) {
            case "www.minecraft.net": {
                return SkinFix.stripIfPrefixed(uRL.getPath(), "/skin/");
            }
            case "s3.amazonaws.com": 
            case "skins.minecraft.net": {
                return SkinFix.stripIfPrefixed(uRL.getPath(), "/MinecraftSkins/");
            }
        }
        return null;
    }

    private static String findCapeOwner(URL uRL) {
        switch (uRL.getHost()) {
            case "www.minecraft.net": {
                if (!uRL.getPath().equals("/cloak/get.jsp")) {
                    return null;
                }
                return SkinFix.stripIfPrefixed(uRL.getQuery(), "user=");
            }
            case "s3.amazonaws.com": 
            case "skins.minecraft.net": {
                return SkinFix.stripIfPrefixed(uRL.getPath(), "/MinecraftCloaks/");
            }
        }
        return null;
    }

    private static String stripIfPrefixed(String string, String string2) {
        if (string != null && string.startsWith(string2)) {
            if ((string = string.substring(string2.length())).endsWith(".png")) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            return string;
        }
        return null;
    }
}

