/*
 * Decompiled with CFR 0.152.
 */
package tr.org.yongdohyun.projtlauncher.normal.launcher.impl;

import java.util.ArrayList;
import java.util.List;
import tr.org.yongdohyun.projtlauncher.normal.exception.ParseException;
import tr.org.yongdohyun.projtlauncher.normal.launcher.Launcher;
import tr.org.yongdohyun.projtlauncher.normal.utils.Parameters;

public abstract class AbstractLauncher
implements Launcher {
    private static final int DEFAULT_WINDOW_WIDTH = 854;
    private static final int DEFAULT_WINDOW_HEIGHT = 480;
    protected final List<String> gameArgs;
    protected final int width;
    protected final int height;
    protected final boolean maximize;
    protected final String serverAddress;
    protected final String serverPort;
    protected final String worldName;
    protected final String mainClassName;

    protected AbstractLauncher(Parameters parameters) {
        this.gameArgs = parameters.getList("param", new ArrayList<String>());
        this.mainClassName = parameters.getString("mainClass", "net.minecraft.client.Minecraft");
        this.serverAddress = parameters.getString("serverAddress", null);
        this.serverPort = parameters.getString("serverPort", null);
        this.worldName = parameters.getString("worldName", null);
        String string = parameters.getString("windowParams", null);
        if (!"maximized".equals(string) && string != null) {
            this.maximize = false;
            String[] stringArray = string.split("x", 2);
            if (stringArray.length == 2) {
                try {
                    this.width = Integer.parseInt(stringArray[0]);
                    this.height = Integer.parseInt(stringArray[1]);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ParseException(string, "[width]x[height]");
        }
        this.maximize = string != null;
        this.width = 854;
        this.height = 480;
    }
}

