/*
 * Decompiled with CFR 0.152.
 */
package tr.org.yongdohyun.projtlauncher.legacy;

import java.applet.Applet;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import tr.org.yongdohyun.projtlauncher.legacy.LegacyFrame;
import tr.org.yongdohyun.projtlauncher.normal.launcher.impl.AbstractLauncher;
import tr.org.yongdohyun.projtlauncher.normal.utils.Parameters;
import tr.org.yongdohyun.projtlauncher.normal.utils.ReflectionUtils;
import tr.org.yongdohyun.projtlauncher.normal.utils.logging.Log;

final class LegacyLauncher
extends AbstractLauncher {
    private final String user;
    private final String session;
    private final String title;
    private final String appletClass;
    private final boolean useApplet;
    private final String gameDir;

    public LegacyLauncher(Parameters parameters) {
        super(parameters);
        this.user = parameters.getString("userName");
        this.session = parameters.getString("sessionId");
        this.title = parameters.getString("windowTitle", "Minecraft");
        this.appletClass = parameters.getString("appletClass", "net.minecraft.client.MinecraftApplet");
        List list = parameters.getList("traits", Collections.emptyList());
        this.useApplet = !list.contains("noapplet");
        this.gameDir = System.getProperty("user.dir");
    }

    public void launch() throws Throwable {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(this.mainClassName);
        Field field = LegacyLauncher.findMinecraftGameDirField(clazz);
        if (field != null) {
            field.setAccessible(true);
            field.set(null, new File(this.gameDir));
        }
        if (this.useApplet) {
            System.setProperty("minecraft.applet.TargetDirectory", this.gameDir);
            try {
                LegacyFrame legacyFrame = new LegacyFrame(this.title, LegacyLauncher.createAppletClass(this.appletClass));
                legacyFrame.start(this.user, this.session, this.width, this.height, this.maximize, this.serverAddress, this.serverPort, this.gameArgs.contains("--demo"));
                return;
            }
            catch (Throwable throwable) {
                Log.error((String)"Running applet wrapper failed with exception; falling back to main class", (Throwable)throwable);
            }
        }
        MethodHandle methodHandle = ReflectionUtils.findMainMethod(clazz);
        methodHandle.invokeExact(this.gameArgs.toArray(new String[0]));
    }

    private static Applet createAppletClass(String string) throws Throwable {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
        MethodHandle methodHandle = MethodHandles.lookup().findConstructor(clazz, MethodType.methodType(Void.TYPE));
        return methodHandle.invoke();
    }

    private static Field findMinecraftGameDirField(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            int n;
            if (field.getType() != File.class || !Modifier.isStatic(n = field.getModifiers()) || !Modifier.isPrivate(n) || Modifier.isFinal(n)) continue;
            return field;
        }
        return null;
    }
}

