/*
 * Decompiled with CFR 0.152.
 */
package tr.org.yongdohyun.projtlauncher.legacy.utils.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tr.org.yongdohyun.projtlauncher.legacy.utils.json.JsonParseException;

public final class JsonParser {
    private final Reader in;
    private char[] buffer;
    private int pos;
    private int length;

    public static Object parse(String string) throws IOException {
        return JsonParser.parse(new StringReader(string));
    }

    public static Object parse(InputStream inputStream) throws IOException {
        return JsonParser.parse(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static Object parse(Reader reader) throws IOException {
        return new JsonParser(reader).readSingleValue();
    }

    private JsonParser(Reader reader) throws IOException {
        this.in = reader;
        this.length = 0;
        this.pos = 0;
        this.read();
    }

    private int character() {
        if (this.length == -1) {
            return -1;
        }
        return this.buffer[this.pos];
    }

    private int read() throws IOException {
        if (this.length == -1) {
            return -1;
        }
        if (this.buffer == null || this.pos++ == this.length - 1) {
            this.pos = 0;
            this.buffer = new char[8192];
            this.length = this.in.read(this.buffer);
        }
        return this.character();
    }

    private void assertCharacter(char c) throws JsonParseException {
        if (this.character() != c) {
            throw new JsonParseException("Expected '" + c + "' but got " + (this.character() != -1 ? "'" + (char)this.character() + "'" : "EOF"));
        }
    }

    private void assertNoEOF(String string) throws JsonParseException {
        if (this.character() == -1) {
            throw new JsonParseException("Expected " + string + " but got EOF");
        }
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace()) {
            this.read();
        }
    }

    private boolean isWhitespace() {
        return this.character() == 32 || this.character() == 10 || this.character() == 13 || this.character() == 9;
    }

    private Object readSingleValue() throws IOException {
        this.skipWhitespace();
        Object object = this.readValue();
        if (!(object instanceof Double)) {
            this.read();
        }
        this.skipWhitespace();
        if (this.character() != -1) {
            throw new JsonParseException("Found trailing non-whitespace characters");
        }
        return object;
    }

    private Object readValue() throws IOException {
        this.assertNoEOF("a value");
        int n = this.character();
        switch (n) {
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: {
                return this.readString();
            }
            case 102: 
            case 116: {
                Boolean bl = this.readBoolean();
                if (bl == null) break;
                return bl;
            }
            case 110: {
                if (!this.readNull()) break;
                return null;
            }
        }
        if (n == 45 || this.isDigit()) {
            return this.readNumber();
        }
        throw new JsonParseException("Expected a JSON value but got '" + (char)n + "'");
    }

    private Map<String, Object> readObject() throws IOException {
        this.assertCharacter('{');
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = false;
        this.read();
        this.skipWhitespace();
        while (this.character() != 125) {
            if (bl) {
                this.assertCharacter(',');
                this.read();
                this.skipWhitespace();
            }
            String string = this.readString();
            this.read();
            this.skipWhitespace();
            this.assertCharacter(':');
            this.read();
            this.skipWhitespace();
            Object object = this.readValue();
            hashMap.put(string, object);
            if (!(object instanceof Double)) {
                this.read();
            }
            this.skipWhitespace();
            bl = true;
        }
        return hashMap;
    }

    private List<Object> readArray() throws IOException {
        this.assertCharacter('[');
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        this.read();
        this.skipWhitespace();
        while (this.character() != 93) {
            if (bl) {
                this.assertCharacter(',');
                this.read();
                this.skipWhitespace();
            }
            Object object = this.readValue();
            arrayList.add(object);
            if (!(object instanceof Double)) {
                this.read();
            }
            this.skipWhitespace();
            bl = true;
        }
        return arrayList;
    }

    private String readString() throws IOException {
        this.assertCharacter('\"');
        StringBuilder stringBuilder = new StringBuilder();
        block18: while (this.read() != 34) {
            int n = this.character();
            if (n >= 0 && n <= 31) {
                throw new JsonParseException("Found unescaped control character within string");
            }
            block1 : switch (n) {
                case -1: {
                    throw new JsonParseException("Expected '\"' but got EOF");
                }
                case 127: {
                    if (this.read() != 34) continue block18;
                    return stringBuilder.toString();
                }
                case 92: {
                    int n2 = this.read();
                    switch (n2) {
                        case -1: {
                            throw new JsonParseException("Expected an escape sequence but got EOF");
                        }
                        case 92: {
                            break block1;
                        }
                        case 34: 
                        case 47: {
                            n = n2;
                            break block1;
                        }
                        case 98: {
                            n = 8;
                            break block1;
                        }
                        case 102: {
                            n = 12;
                            break block1;
                        }
                        case 110: {
                            n = 10;
                            break block1;
                        }
                        case 114: {
                            n = 13;
                            break block1;
                        }
                        case 116: {
                            n = 9;
                            break block1;
                        }
                        case 117: {
                            char[] cArray = new char[4];
                            for (int i = 0; i < cArray.length; ++i) {
                                n = this.read();
                                if (i == 0 && this.character() == 45) {
                                    throw new JsonParseException("Hex sequence may not be negative");
                                }
                                if (this.character() == -1) {
                                    throw new JsonParseException("Expected a hex sequence but got EOF");
                                }
                                cArray[i] = (char)n;
                            }
                            String string = new String(cArray);
                            try {
                                n = Integer.parseInt(string, 16);
                                break block1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new JsonParseException("Could not parse hex sequence \"" + string + "\"");
                            }
                        }
                    }
                    throw new JsonParseException("Invalid escape sequence: \\" + (char)n2);
                }
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private boolean isDigit() {
        return this.character() >= 48 && this.character() <= 57;
    }

    private Double readNumber() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.character() == 45) {
            stringBuilder.append((char)this.character());
            this.read();
        }
        if (this.character() == 48) {
            stringBuilder.append((char)this.character());
            this.read();
            if (this.isDigit()) {
                throw new JsonParseException("Found superfluous leading zero");
            }
        } else if (!this.isDigit()) {
            throw new JsonParseException("Expected digits");
        }
        while (this.character() != -1 && this.isDigit()) {
            stringBuilder.append((char)this.character());
            this.read();
        }
        if (this.character() == 46) {
            stringBuilder.append('.');
            this.read();
            this.assertNoEOF("digits");
            if (!this.isDigit()) {
                throw new JsonParseException("Expected digits after decimal point");
            }
            while (this.character() != -1 && this.isDigit()) {
                stringBuilder.append((char)this.character());
                this.read();
            }
        }
        if (this.character() == 101 || this.character() == 69) {
            stringBuilder.append('E');
            this.read();
            this.assertNoEOF("digits");
            if (this.character() == 43 || this.character() == 45) {
                stringBuilder.append((char)this.character());
                this.read();
            }
            if (this.character() != 43 && this.character() != 45 && !this.isDigit()) {
                throw new JsonParseException("Expected exponent digits");
            }
            while (this.character() != -1 && this.isDigit()) {
                stringBuilder.append((char)this.character());
                this.read();
            }
        }
        String string = stringBuilder.toString();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonParseException("Failed to parse number '" + string + "'");
        }
    }

    private Boolean readBoolean() throws IOException {
        if (this.character() == 116) {
            if (this.read() == 114 && this.read() == 117 && this.read() == 101) {
                return true;
            }
        } else if (this.character() == 102 && this.read() == 97 && this.read() == 108 && this.read() == 115 && this.read() == 101) {
            return false;
        }
        return null;
    }

    private boolean readNull() throws IOException {
        return this.character() == 110 && this.read() == 117 && this.read() == 108 && this.read() == 108;
    }
}

